clear all
res = 1000;%resolution
c = 2.998e8;
Vector = ones(res,1);
Pitch = linspace(1,3,res); % In microns %lower than 1.5 is too difficult to make
d_Pitch = linspace(0.2,0.8,res); %No lower than 0.2 as stated in SK higher then 0.85 does wierd shit too
testzdw = 1.041;

%% Plotting skewness for fibre parameter pairs


Skewness_B=[];%residual skewness bandwidth (both require the idx of the ZDW
Broadband_Bandwidth=[];
%my fucntion (windows around zero point
%Lambda_ZGVD_idx=[];%not useful for variable lam_max
Lambda_ZDW=[];        
testpara=[];    
Lambda_min=0.5;%microns
Lambda_max=2; %SK breaks down at 1.5*Pitch %Bulk silica zero dispersion at 1.3um so no point looking much above there for first zero dispersion wavelength
Omega_max=f2w(Lambda_max);
Omega_min=f2w(Lambda_min);
Omega_scan=linspace(Omega_min,Omega_max,2*res);
d_omega=(Omega_max-Omega_min)/(2*res);
Lambda_scan=f2w(Omega_scan);
    
for i=1:length(Pitch)       

    Skewness_row_B=[];
    Lambda_ZDW_row=[];
    Broadband_Bandwidth_row=[];
    
    for j=1:length(d_Pitch)


        n_scan=n_eff_SK(Lambda_scan,d_Pitch(j),Pitch(i),n_silica(Lambda_scan));
        d_n_scan= diff(n_scan)./diff(Lambda_scan);									% dneff/dlambda

        n_scan1=n_scan(:,1:end-1); %one entry smaller
        Lambda_scan1=Lambda_scan(:,1:end-1); %one entry smaller
        Omega_scan1 =Omega_scan(:,1:end-1);
        
        n_group =  n_scan1- Lambda_scan1.*d_n_scan;
        v_group= c./n_group;%Group velocity
        
        Lambda_scan2 = Lambda_scan(:,1:end-2);										% New lambda vector with two fewer entries
        Omega_scan2 = Omega_scan(:,1:end-2);

        d2_n_scan = diff(d_n_scan)./diff(Lambda_scan1);								% d2neff/dlam
        Dispersion = -1e18*(Lambda_scan2./c).*d2_n_scan;
        [ZDW,idx]=ZeroPoint_vec(Lambda_scan2,Dispersion,1);
        if ZDW>=1.4                                                                 %corresponds to idx 283 in Lambda_scan1 for res=300
            idx=0;
        end
         
        Lambda_ZDW_row=[Lambda_ZDW_row,ZDW];

        Skew_B=Skewness_Bandwidth(idx,v_group,5E7);
        omega_high = w2f(ZDW)+ (Skew_B*d_omega); 
        omega_low = w2f(ZDW)- (Skew_B*d_omega);
        Bandwidth_Lambda = f2w(omega_high)-f2w(omega_low);
        Broadband_Bandwidth_row=[Broadband_Bandwidth_row,Bandwidth_Lambda];
        Skewness_row_B=[Skewness_row_B,Skew_B];


    end
     dif=(abs(Lambda_ZDW_row-testzdw));
     [value,testidx]=min(dif);

     testparaloop= [Pitch(i),d_Pitch(testidx)];
     testpara=vertcat(testpara,testparaloop);

       

     Lambda_ZDW=vertcat(Lambda_ZDW,Lambda_ZDW_row);   
     Skewness_B=vertcat(Skewness_B,Skewness_row_B);
     Broadband_Bandwidth=vertcat(Broadband_Bandwidth,Broadband_Bandwidth_row);

     
end
     



figure(1)
imagesc(d_Pitch,Pitch,abs(Broadband_Bandwidth))
xlabel('d/Pitch'); ylabel('Pitch [um]');
set(gca, 'YDir','normal')
levels =[0.978 1.041];
hold on
% plot(testpara(:,2),testpara(:,1),'k')
contour(d_Pitch,Pitch,real(Lambda_ZDW),levels,'k','ShowText','on');
